export type AwaitQueueTask<T> = () => (T | PromiseLike<T>);
export type AwaitQueueTaskDump = {
    idx: number;
    task: AwaitQueueTask<unknown>;
    name?: string;
    enqueuedTime: number;
    executionTime: number;
};
/**
 * Custom Error derived class used to reject pending tasks once stop() method
 * has been called.
 */
export declare class AwaitQueueStoppedError extends Error {
    constructor(message?: string);
}
/**
 * Custom Error derived class used to reject pending tasks once removeTask()
 * method has been called.
 */
export declare class AwaitQueueRemovedTaskError extends Error {
    constructor(message?: string);
}
export declare class AwaitQueue {
    private readonly pendingTasks;
    private nextTaskId;
    private stopping;
    get size(): number;
    push<T>(task: AwaitQueueTask<T>, name?: string): Promise<T>;
    stop(): void;
    remove(taskIdx: number): void;
    dump(): AwaitQueueTaskDump[];
    private execute;
}
//# sourceMappingURL=index.d.ts.map